/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import java.util.ArrayList;
import java.util.Random;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRMod;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.biome.LOTRMusicRegion;
import lotr.common.world.biome.variant.LOTRBiomeVariant;
import lotr.common.world.feature.LOTRTreeType;
import lotr.common.world.feature.LOTRWorldGenClover;
import lotr.common.world.feature.LOTRWorldGenDoubleFlower;
import lotr.common.world.map.LOTRRoadType;
import lotr.common.world.map.LOTRWaypoint;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;

public class LOTRBiomeSunLands
extends LOTRBiome {
    public LOTRBiomeSunLands(int i, boolean major) {
        super(i, major);
        this.field_76762_K.clear();
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityPig.class, 20, 2, 6));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntitySheep.class, 20, 2, 6));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityCow.class, 5, 1, 4));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityChicken.class, 5, 1, 4));
        this.npcSpawnList.clear();
        this.variantChance = 0.3f;
        this.decorator.addOre((WorldGenerator)new WorldGenMinable(LOTRMod.oreMithril2, 5), 0.16f, 0, 16);
        this.decorator.addOre((WorldGenerator)new WorldGenMinable(LOTRMod.oreMithril, 10), 0.65f, 0, 16);
        this.addBiomeVariant(LOTRBiomeVariant.HILLS);
        this.addBiomeVariant(LOTRBiomeVariant.HILLS_FOREST);
        this.addBiomeVariant(LOTRBiomeVariant.STEPPE);
        this.decorator.resetTreeCluster();
        this.decorator.willowPerChunk = 1;
        this.decorator.flowersPerChunk = 1;
        this.decorator.doubleFlowersPerChunk = 1;
        this.decorator.generateWater = false;
        this.decorator.generateLava = false;
        this.decorator.grassPerChunk = 6;
        this.decorator.doubleGrassPerChunk = 4;
        this.decorator.addTree(LOTRTreeType.PALM, 200);
        this.decorator.addTree(LOTRTreeType.DATE_PALM, 20);
        this.biomeColors.setGrass(11009024);
        ArrayList flowerDupes = new ArrayList();
        for (int l = 0; l < 10; ++l) {
            this.flowers.clear();
            this.registerPlainsFlowers();
            flowerDupes.addAll(this.flowers);
        }
        this.flowers.clear();
        this.flowers.addAll(flowerDupes);
        this.addFlower(LOTRMod.athelas, 0, 10);
        this.addFlower(LOTRMod.torchflower, 0, 10);
        this.decorator.generateOrcDungeon = false;
    }

    @Override
    public LOTRWaypoint.Region getBiomeWaypoints() {
        return LOTRWaypoint.Region.SUN;
    }

    @Override
    public LOTRAchievement getBiomeAchievement() {
        return LOTRAchievement.enterSun;
    }

    @Override
    public LOTRMusicRegion.Sub getBiomeMusic() {
        return LOTRMusicRegion.SUN.getSubregion("sun");
    }

    @Override
    public WorldGenerator getRandomWorldGenForDoubleFlower(Random random) {
        if (random.nextInt(4) == 0) {
            LOTRWorldGenDoubleFlower doubleFlowerGen = new LOTRWorldGenDoubleFlower();
            doubleFlowerGen.setFlowerType(4);
            return doubleFlowerGen;
        }
        return super.getRandomWorldGenForDoubleFlower(random);
    }

    @Override
    public void func_76728_a(World world, Random random, int i, int k) {
        super.func_76728_a(world, random, i, k);
        for (int l = 0; l < this.decorator.grassPerChunk / 2; ++l) {
            int i12 = i + random.nextInt(16) + 8;
            int j12 = random.nextInt(128);
            int k12 = k + random.nextInt(16) + 8;
            new LOTRWorldGenClover().func_76484_a(world, random, i12, j12, k12);
        }
    }

    @Override
    public boolean isHiddenBiome() {
        return false;
    }

    @Override
    public float getTreeIncreaseChance() {
        return 0.03f;
    }

    @Override
    public float getChanceToSpawnAnimals() {
        return 0.25f;
    }

    @Override
    public LOTRRoadType getRoadBlock() {
        return LOTRRoadType.PAVED_PATH;
    }
}

